const http = require('http');
const assert = require('assert');

// Test health endpoint
function testHealthEndpoint() {
    return new Promise((resolve, reject) => {
        http.get('http://localhost:3000/api/health', (res) => {
            let data = '';
            res.on('data', (chunk) => {
                data += chunk;
            });
            res.on('end', () => {
                try {
                    const result = JSON.parse(data);
                    assert.strictEqual(result.status, 'ok', 'Health check should return status ok');
                    console.log('✓ Health endpoint test passed');
                    resolve();
                } catch (err) {
                    reject(err);
                }
            });
        }).on('error', reject);
    });
}

// Test static files are served
function testStaticFiles() {
    return new Promise((resolve, reject) => {
        http.get('http://localhost:3000/', (res) => {
            assert.strictEqual(res.statusCode, 200, 'Home page should return 200');
            console.log('✓ Static files test passed');
            resolve();
        }).on('error', reject);
    });
}

// Run all tests
async function runTests() {
    console.log('Running tests...\n');
    try {
        await testHealthEndpoint();
        await testStaticFiles();
        console.log('\n✓ All tests passed!');
        process.exit(0);
    } catch (error) {
        console.error('\n✗ Test failed:', error.message);
        process.exit(1);
    }
}

runTests();
